using System;
using VRM.Integration.Servicebus.Core;

namespace VIMT.IMS.Configuration
{
	public class VirtualMeetingRoomConfiguration : ObjectConfigHandler
	{
		private readonly string _orgName;
		
		public VirtualMeetingRoomConfiguration(string orgName)
		{
			_orgName = orgName;
		}
		public VirtualMeetingRoomConfiguration()
		{
		}
		
		public VirtualMeetingRoomConfiguration Current
		{
			get
			{
				var customConfigurationFileReader = new CustomConfigurationFileReader();
				
				var section = customConfigurationFileReader.GetCustomConfig<VirtualMeetingRoomConfiguration>(
					ConfigurationLocation.ConfigDefiningAssemblyPath,
					ConfigurationLocation.GetConfigFilePath(_orgName),
					"VirtualMeetingRoomConfiguration");
				if (section == null)
					throw new Exception("The IMS Custom Settings configuration section has not been specified");
				return section;
			}
		}
		public bool IMS { get; set; }
	}
}
